/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes;

import com.cobblemon.mod.relocations.oracle.js.parser.ir.Module;
import com.cobblemon.mod.relocations.oracle.truffle.api.CallTarget;
import com.cobblemon.mod.relocations.oracle.truffle.api.RootCallTarget;
import com.cobblemon.mod.relocations.oracle.truffle.api.Truffle;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.FrameDescriptor;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.FrameSlotKind;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.LoopNode;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.NodeUtil;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.RepeatingNode;
import com.cobblemon.mod.relocations.oracle.truffle.api.source.SourceSection;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.decorators.DecoratorListEvaluationNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JSFrameDescriptor;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JSFrameSlot;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.AsyncIteratorNextNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ClearFrameSlotsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.CompoundWriteElementNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ConstantVariableWriteNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.DebugScopeVarWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.DeclareGlobalFunctionNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.DeclareGlobalLexicalVariableNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.DeclareGlobalNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.DeclareGlobalVariableNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.EnumerateNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GetTemplateObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalDeclarationInstantiationNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalPropertyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalScopeNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalScopeVarWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.InitializeInstanceElementsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorCompleteUnaryNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorGetNextValueNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorIsDoneNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorNextUnaryNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorSetDoneNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorToArrayNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSConstantNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentRead;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentWrite;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSTargetableWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.LocalVarIncNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.NewPrivateNameNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.OptionalChainNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PrivateBrandCheckNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PrivateFieldGetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PrivateFieldSetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PropertyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ReadElementNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.RegExpLiteralNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.RestObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.SuperPropertyReferenceNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.WithTargetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.WithVarWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.WriteElementNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.WritePropertyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessArgumentsArrayDirectlyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessDerivedConstructorThisNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessFrameArgumentNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessFunctionNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessLevelFunctionNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessLexicalThisNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessRestArgumentsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessThisNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.AccessVarArgsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.arguments.ArgumentsObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.DualNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.InNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSAddNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSAndNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSBitwiseAndNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSBitwiseOrNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSBitwiseXorNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSDivideNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSEqualNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSExponentiateNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSGreaterOrEqualNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSGreaterThanNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSLeftShiftNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSLessOrEqualNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSLessThanNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSModuloNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSMultiplyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSNullishCoalescingNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSOrNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSRightShiftNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSSubtractNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSTypeofIdenticalNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.JSUnsignedRightShiftNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.binary.PrivateFieldInNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSPrepareThisNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.AbstractBlockNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.AsyncFunctionBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.AsyncGeneratorBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.AsyncGeneratorYieldNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.AsyncIteratorCloseWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.AwaitNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.BreakNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.BreakTarget;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ContinueNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ContinueTarget;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ContinueTargetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.DebuggerNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.DirectBreakTargetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.EmptyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ExprBlockNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ForNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.GeneratorBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.GeneratorExprBlockNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.GeneratorVoidBlockNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.IfNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.IteratorCloseWrapperNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.LabelNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ModuleBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ModuleInitializeEnvironmentNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ModuleYieldNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ResumableNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ReturnNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ReturnTargetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.RuntimeErrorNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.StatementNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.SwitchNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.ThrowNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.TopLevelAwaitModuleBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.TryCatchNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.TryFinallyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.VoidBlockNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.WhileNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.WithNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.control.YieldNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.AbstractBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.CallApplyArgumentsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.ClassDefinitionNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.ConstructorResultNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.ConstructorRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.DefaultDerivedConstructorSuperCallNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.IterationScopeNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSFunctionArgumentsNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSNewNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.NamedEvaluationNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.NewTargetRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.SpreadArgumentNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.module.ImportMetaNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.module.ReadImportBindingNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.module.ResolveNamedImportNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.module.ResolveStarImportNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.promise.ImportCallNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.JSComplementNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.JSNotNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.JSUnaryMinusNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.JSUnaryPlusNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.TypeOfNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.unary.VoidNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Evaluator;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSErrorType;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JavaScriptRealmBoundaryRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.SafeInteger;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSFunction;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Undefined;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.InternalSlotId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeFactory {
    private static final NodeFactory FACTORY = new NodeFactory();

    public JavaScriptNode createUnary(UnaryOperation operation, JavaScriptNode operand) {
        switch (operation) {
            case BITWISE_COMPLEMENT: {
                return JSComplementNode.create(operand);
            }
            case MINUS: {
                return JSUnaryMinusNode.create(operand);
            }
            case PLUS: {
                return JSUnaryPlusNode.create(operand);
            }
            case NOT: {
                return JSNotNode.create(operand);
            }
            case TYPE_OF: {
                return TypeOfNode.create(operand);
            }
            case VOID: {
                return VoidNode.create(operand);
            }
        }
        throw new IllegalArgumentException();
    }

    public JavaScriptNode createLocalVarInc(UnaryOperation operation, JSFrameSlot frameSlot, boolean hasTemporalDeadZone, ScopeFrameNode scopeFrameNode) {
        switch (operation) {
            case POSTFIX_LOCAL_INCREMENT: {
                return LocalVarIncNode.createPostfix(LocalVarIncNode.Op.Inc, frameSlot, hasTemporalDeadZone, scopeFrameNode);
            }
            case PREFIX_LOCAL_INCREMENT: {
                return LocalVarIncNode.createPrefix(LocalVarIncNode.Op.Inc, frameSlot, hasTemporalDeadZone, scopeFrameNode);
            }
            case POSTFIX_LOCAL_DECREMENT: {
                return LocalVarIncNode.createPostfix(LocalVarIncNode.Op.Dec, frameSlot, hasTemporalDeadZone, scopeFrameNode);
            }
            case PREFIX_LOCAL_DECREMENT: {
                return LocalVarIncNode.createPrefix(LocalVarIncNode.Op.Dec, frameSlot, hasTemporalDeadZone, scopeFrameNode);
            }
        }
        throw new IllegalArgumentException();
    }

    public JavaScriptNode createToNumericOperand(JavaScriptNode operand) {
        return JSToNumericNode.createToNumericOperand(operand);
    }

    public JavaScriptNode createDual(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        if (left instanceof EmptyNode) {
            return right;
        }
        return this.createBinary(context, BinaryOperation.DUAL, left, right);
    }

    public JavaScriptNode createBinary(JSContext context, BinaryOperation operation, JavaScriptNode left, JavaScriptNode right) {
        switch (operation) {
            case ADD: {
                return JSAddNode.create(left, right, false);
            }
            case SUBTRACT: {
                return JSSubtractNode.create(left, right, false);
            }
            case MULTIPLY: {
                return JSMultiplyNode.create(left, right);
            }
            case EXPONENTIATE: {
                return JSExponentiateNode.create(left, right);
            }
            case DIVIDE: {
                return JSDivideNode.create(left, right);
            }
            case MODULO: {
                return JSModuloNode.create(left, right);
            }
            case EQUAL: {
                return NodeFactory.createBinaryEqual(left, right);
            }
            case GREATER: {
                return JSGreaterThanNode.create(left, right);
            }
            case GREATER_OR_EQUAL: {
                return JSGreaterOrEqualNode.create(left, right);
            }
            case IDENTICAL: {
                return NodeFactory.createBinaryIdentical(left, right);
            }
            case LESS: {
                return JSLessThanNode.create(left, right);
            }
            case LESS_OR_EQUAL: {
                return JSLessOrEqualNode.create(left, right);
            }
            case NOT_EQUAL: {
                return JSNotNode.create(NodeFactory.createBinaryEqual(left, right));
            }
            case NOT_IDENTICAL: {
                return JSNotNode.create(NodeFactory.createBinaryIdentical(left, right));
            }
            case LOGICAL_AND: {
                return JSAndNode.create(left, right);
            }
            case LOGICAL_OR: {
                return JSOrNode.create(left, right);
            }
            case NULLISH_COALESCING: {
                return JSNullishCoalescingNode.create(left, right);
            }
            case BITWISE_AND: {
                return JSBitwiseAndNode.create(left, right);
            }
            case BITWISE_OR: {
                return JSBitwiseOrNode.create(left, right);
            }
            case BITWISE_XOR: {
                return JSBitwiseXorNode.create(left, right);
            }
            case BITWISE_LEFT_SHIFT: {
                return JSLeftShiftNode.create(left, right);
            }
            case BITWISE_RIGHT_SHIFT: {
                return JSRightShiftNode.create(left, right);
            }
            case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                return JSUnsignedRightShiftNode.create(left, right);
            }
            case INSTANCEOF: {
                return InstanceofNode.create(context, left, right);
            }
            case IN: {
                return InNode.create(context, left, right);
            }
            case DUAL: {
                return DualNode.create(left, right);
            }
        }
        throw new IllegalArgumentException();
    }

    private static JavaScriptNode createBinaryIdentical(JavaScriptNode left, JavaScriptNode right) {
        JavaScriptNode node = NodeFactory.createIdenticalSpecial(left, right);
        if (node != null) {
            return node;
        }
        return JSIdenticalNode.create(left, right);
    }

    private static JavaScriptNode createBinaryEqual(JavaScriptNode left, JavaScriptNode right) {
        JavaScriptNode node = NodeFactory.createIdenticalSpecial(left, right);
        if (node != null) {
            return node;
        }
        return JSEqualNode.create(left, right);
    }

    private static JavaScriptNode createIdenticalSpecial(JavaScriptNode left, JavaScriptNode right) {
        if (left instanceof TypeOfNode && right instanceof JSConstantNode.JSConstantStringNode) {
            return JSTypeofIdenticalNode.create(((TypeOfNode)left).getOperand(), (JSConstantNode.JSConstantStringNode)right);
        }
        if (right instanceof TypeOfNode && left instanceof JSConstantNode.JSConstantStringNode) {
            return JSTypeofIdenticalNode.create(((TypeOfNode)right).getOperand(), (JSConstantNode.JSConstantStringNode)left);
        }
        return null;
    }

    public JavaScriptNode createTypeofIdentical(JavaScriptNode subject, TruffleString typeString) {
        return JSTypeofIdenticalNode.create(subject, typeString);
    }

    public JavaScriptNode createLogicalOr(JavaScriptNode left, JavaScriptNode right) {
        return JSOrNode.create(left, right);
    }

    public JavaScriptNode createNotUndefinedOr(JavaScriptNode left, JavaScriptNode right) {
        return JSOrNode.createNotUndefinedOr(left, right);
    }

    public JavaScriptNode createConstant(Object value) {
        return JSConstantNode.create(value);
    }

    public JavaScriptNode createConstantBoolean(boolean value) {
        return JSConstantNode.createBoolean(value);
    }

    public JavaScriptNode createConstantInteger(int value) {
        return JSConstantNode.createInt(value);
    }

    public JavaScriptNode createConstantSafeInteger(long value) {
        return JSConstantNode.createSafeInteger(SafeInteger.valueOf(value));
    }

    public JavaScriptNode createConstantNumericUnit() {
        return JSConstantNode.createConstantNumericUnit();
    }

    public JavaScriptNode createConstantDouble(double value) {
        return JSConstantNode.createDouble(value);
    }

    public JavaScriptNode createConstantString(TruffleString value) {
        return JSConstantNode.createString(value);
    }

    public JavaScriptNode createConstantUndefined() {
        return JSConstantNode.createUndefined();
    }

    public JavaScriptNode createConstantNull() {
        return JSConstantNode.createNull();
    }

    public IfNode createIf(JavaScriptNode condition, JavaScriptNode pass, JavaScriptNode fail) {
        return IfNode.create(condition, pass, fail);
    }

    public SwitchNode createSwitch(JavaScriptNode[] declarations, JavaScriptNode[] caseExpressions, int[] jumptable, JavaScriptNode[] statements) {
        return SwitchNode.create(declarations, caseExpressions, jumptable, statements);
    }

    public LoopNode createLoopNode(RepeatingNode repeatingNode) {
        return Truffle.getRuntime().createLoopNode(repeatingNode);
    }

    public RepeatingNode createWhileDoRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
        return WhileNode.createWhileDoRepeatingNode(condition, body);
    }

    public JavaScriptNode createWhileDo(LoopNode loopNode) {
        return WhileNode.createWhileDo(loopNode);
    }

    public AbstractBlockNode fixBlockNodeChild(AbstractBlockNode blockNode, int index, JavaScriptNode newChild) {
        assert (blockNode.getStatements()[index] != newChild);
        blockNode.getStatements()[index] = newChild;
        return blockNode;
    }

    public Node fixNodeChild(Node parent, Node child, Node newChild) {
        assert (child != newChild);
        boolean ok = NodeUtil.replaceChild(parent, child, newChild);
        assert (ok);
        return parent;
    }

    public RepeatingNode createDoWhileRepeatingNode(JavaScriptNode condition, JavaScriptNode body) {
        return WhileNode.createDoWhileRepeatingNode(condition, body);
    }

    public JavaScriptNode createDoWhile(LoopNode loopNode) {
        return WhileNode.createDoWhile(loopNode);
    }

    public JavaScriptNode createDesugaredFor(LoopNode loopNode) {
        return WhileNode.createDesugaredFor(loopNode);
    }

    public JavaScriptNode createDesugaredForOf(LoopNode loopNode) {
        return WhileNode.createDesugaredForOf(loopNode);
    }

    public JavaScriptNode createDesugaredForIn(LoopNode loopNode) {
        return WhileNode.createDesugaredForIn(loopNode);
    }

    public JavaScriptNode createDesugaredForAwaitOf(LoopNode loopNode) {
        return WhileNode.createDesugaredForAwaitOf(loopNode);
    }

    public RepeatingNode createForRepeatingNode(JavaScriptNode condition, JavaScriptNode body, JavaScriptNode modify, FrameDescriptor frameDescriptor, JavaScriptNode isFirstNode, JavaScriptNode setNotFirstNode, JSFrameSlot blockScopeSlot) {
        IterationScopeNode perIterationScope = this.createIterationScope(frameDescriptor, blockScopeSlot);
        return ForNode.createForRepeatingNode(condition, body, modify, perIterationScope, isFirstNode, setNotFirstNode);
    }

    public StatementNode createFor(LoopNode loopNode) {
        return ForNode.createFor(loopNode);
    }

    public IterationScopeNode createIterationScope(FrameDescriptor frameDescriptor, JSFrameSlot blockScopeSlot) {
        int numberOfSlots = frameDescriptor.getNumberOfSlots();
        assert (numberOfSlots > 0 && ScopeFrameNode.PARENT_SCOPE_IDENTIFIER.equals(frameDescriptor.getSlotName(0)));
        int numberOfSlotsToCopy = numberOfSlots - 1;
        JSReadFrameSlotNode[] reads = new JSReadFrameSlotNode[numberOfSlotsToCopy];
        JSWriteFrameSlotNode[] writes = new JSWriteFrameSlotNode[numberOfSlotsToCopy];
        int slotIndex = 0;
        for (int i = 0; i < numberOfSlots; ++i) {
            if (i == 0) continue;
            JSFrameSlot slot = JSFrameSlot.fromIndexedFrameSlot(frameDescriptor, i);
            reads[slotIndex] = JSReadFrameSlotNode.create(slot, false);
            writes[slotIndex] = JSWriteFrameSlotNode.create(slot, null, false);
            ++slotIndex;
        }
        assert (slotIndex == numberOfSlotsToCopy);
        return IterationScopeNode.create(frameDescriptor, reads, writes, blockScopeSlot.getIndex());
    }

    public BreakNode createBreak(BreakTarget breakTarget) {
        return BreakNode.create(breakTarget);
    }

    public ContinueNode createContinue(ContinueTarget continueTarget) {
        return ContinueNode.create(continueTarget);
    }

    public LabelNode createLabel(JavaScriptNode block, BreakTarget target) {
        return LabelNode.create(block, target);
    }

    public JavaScriptNode createEmpty() {
        return EmptyNode.create();
    }

    public JavaScriptNode createVoidBlock(JavaScriptNode ... statements) {
        return VoidBlockNode.createVoidBlock(statements);
    }

    public JavaScriptNode createExprBlock(JavaScriptNode ... statements) {
        return ExprBlockNode.createExprBlock(statements);
    }

    public ReturnTargetNode createReturnTarget(JavaScriptNode body) {
        return ReturnTargetNode.create(body);
    }

    public ReturnTargetNode createFrameReturnTarget(JavaScriptNode body, JavaScriptNode returnValue) {
        return ReturnTargetNode.createFrameReturnTarget(body, returnValue);
    }

    public ContinueTargetNode createContinueTarget(JavaScriptNode block, ContinueTarget continueTarget) {
        return ContinueTargetNode.create(block, continueTarget);
    }

    public DirectBreakTargetNode createDirectBreakTarget(JavaScriptNode block) {
        return DirectBreakTargetNode.create(block);
    }

    public JavaScriptNode createDebugger() {
        return DebuggerNode.create();
    }

    public JavaScriptNode createLocal(JSFrameSlot frameSlot, int frameLevel, int scopeLevel) {
        return this.createReadFrameSlot(frameSlot, this.createScopeFrame(frameLevel, scopeLevel, null), false);
    }

    public JavaScriptNode createReadFrameSlot(JSFrameSlot frameSlot, ScopeFrameNode scope) {
        return this.createReadFrameSlot(frameSlot, scope, false);
    }

    public JavaScriptNode createReadFrameSlot(JSFrameSlot frameSlot, ScopeFrameNode scope, boolean hasTemporalDeadZone) {
        return JSReadFrameSlotNode.create(frameSlot, scope, hasTemporalDeadZone);
    }

    public JavaScriptNode createReadCurrentFrameSlot(JSFrameSlot frameSlot) {
        return JSReadFrameSlotNode.create(frameSlot, false);
    }

    public JSWriteFrameSlotNode createWriteFrameSlot(JSFrameSlot frameSlot, ScopeFrameNode scope, JavaScriptNode rhs) {
        return JSWriteFrameSlotNode.create(frameSlot, scope, rhs, false);
    }

    public JSWriteFrameSlotNode createWriteFrameSlot(JSFrameSlot frameSlot, ScopeFrameNode scope, JavaScriptNode rhs, boolean hasTemporalDeadZone) {
        return JSWriteFrameSlotNode.create(frameSlot, scope, rhs, hasTemporalDeadZone);
    }

    public JSWriteFrameSlotNode createWriteCurrentFrameSlot(JSFrameSlot frameSlot, JavaScriptNode rhs) {
        return JSWriteFrameSlotNode.create(frameSlot, rhs, false);
    }

    public ScopeFrameNode createScopeFrame(int frameLevel, int scopeLevel, JSFrameSlot blockScopeSlot) {
        return ScopeFrameNode.create(frameLevel, scopeLevel, blockScopeSlot);
    }

    public JavaScriptNode createReadLexicalGlobal(TruffleString name, boolean hasTemporalDeadZone, JSContext context) {
        return GlobalPropertyNode.createLexicalGlobal(context, name, hasTemporalDeadZone);
    }

    public JavaScriptNode createGlobalScope(JSContext context) {
        return GlobalScopeNode.create(context);
    }

    public JavaScriptNode createGlobalScopeTDZCheck(JSContext context, TruffleString name, boolean checkTDZ) {
        if (!checkTDZ) {
            return this.createGlobalScope(context);
        }
        return GlobalScopeNode.createWithTDZCheck(context, name);
    }

    public JavaScriptNode createGlobalVarWrapper(TruffleString varName, JavaScriptNode defaultDelegate, JavaScriptNode dynamicScope, JSTargetableNode scopeAccessNode) {
        return new GlobalScopeVarWrapperNode(varName, defaultDelegate, dynamicScope, scopeAccessNode);
    }

    private static boolean isIndexRange(int[] slots, int from, int to) {
        if (to - from >= 2) {
            for (int i = from + 1; i < to; ++i) {
                if (slots[i - 1] == slots[i] - 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JavaScriptNode createClearFrameSlots(ScopeFrameNode scope, int[] slots) {
        return ClearFrameSlotsNode.create(scope, slots);
    }

    public JavaScriptNode createClearFrameSlotRange(ScopeFrameNode scope, int start, int end) {
        return ClearFrameSlotsNode.createRange(scope, start, end);
    }

    public final JavaScriptNode createClearFrameSlots(ScopeFrameNode scope, int[] slots, int from, int to) {
        if (NodeFactory.isIndexRange(slots, from, to)) {
            return this.createClearFrameSlotRange(scope, slots[from], slots[to - 1] + 1);
        }
        return this.createClearFrameSlots(scope, from == 0 && to == slots.length ? slots : Arrays.copyOfRange(slots, from, to));
    }

    public JavaScriptNode createThrow(JSContext context, JavaScriptNode expression) {
        return ThrowNode.create(expression, context);
    }

    public JavaScriptNode createTryCatch(JSContext context, JavaScriptNode tryNode, JavaScriptNode catchBlock, JavaScriptNode writeErrorVar, BlockScopeNode blockScope, JavaScriptNode destructuring, JavaScriptNode conditionExpression) {
        return TryCatchNode.create(context, tryNode, catchBlock, (JSWriteFrameSlotNode)writeErrorVar, blockScope, destructuring, conditionExpression);
    }

    public JavaScriptNode createTryFinally(JavaScriptNode tryNode, JavaScriptNode finallyBlock) {
        return TryFinallyNode.create(tryNode, finallyBlock);
    }

    public JavaScriptNode createFunctionCall(JSContext context, JavaScriptNode expression, JavaScriptNode[] arguments) {
        if (expression instanceof PropertyNode || expression instanceof ReadElementNode || expression instanceof WithVarWrapperNode || expression instanceof PrivateFieldGetNode || expression instanceof OptionalChainNode.ShortCircuitTargetableNode || expression instanceof OptionalChainNode.OptionalTargetableNode) {
            assert (!(expression instanceof PropertyNode) || ((PropertyNode)expression).isMethod());
            return JSFunctionCallNode.createInvoke((JSTargetableNode)expression, arguments, false, false);
        }
        if (expression instanceof JSTargetableWrapperNode) {
            JavaScriptNode function = ((JSTargetableWrapperNode)expression).getDelegate();
            JavaScriptNode target = ((JSTargetableWrapperNode)expression).getTarget();
            return JSFunctionCallNode.createCall(function, target, arguments, false, false);
        }
        assert (expression != null);
        JavaScriptNode target = null;
        JavaScriptNode function = expression;
        if (function instanceof GlobalPropertyNode) {
            ((GlobalPropertyNode)function).setMethod();
        } else if (function instanceof GlobalScopeVarWrapperNode) {
            ((GlobalScopeVarWrapperNode)function).setMethod();
        }
        return JSFunctionCallNode.createCall(function, target, arguments, false, false);
    }

    public JavaScriptNode createFunctionCallWithNewTarget(JSContext context, JavaScriptNode expression, JavaScriptNode[] arguments) {
        assert (expression instanceof JSTargetableWrapperNode);
        JavaScriptNode function = ((JSTargetableWrapperNode)expression).getDelegate();
        JavaScriptNode target = ((JSTargetableWrapperNode)expression).getTarget();
        return JSFunctionCallNode.createCall(function, target, arguments, false, true);
    }

    public AbstractFunctionArgumentsNode createFunctionArguments(JSContext context, JavaScriptNode[] arguments) {
        return JSFunctionArgumentsNode.create(context, arguments);
    }

    public JavaScriptNode createNew(JSContext context, JavaScriptNode function, AbstractFunctionArgumentsNode arguments) {
        assert (!(function instanceof PropertyNode) || !((PropertyNode)function).isMethod());
        return JSNewNode.create(context, function, arguments);
    }

    public JavaScriptNode createAccessThis() {
        return AccessThisNode.create();
    }

    public JavaScriptNode createAccessCallee(int level) {
        if (level == 0) {
            return AccessFunctionNode.create();
        }
        return AccessLevelFunctionNode.create(level);
    }

    public JavaScriptNode createAccessLexicalThis() {
        return AccessLexicalThisNode.create(this.createAccessCallee(0));
    }

    public JavaScriptNode createAccessArgument(int index) {
        return AccessIndexedArgumentNode.create(index);
    }

    public JavaScriptNode createAccessVarArgs(int startIndex) {
        return AccessVarArgsNode.create(startIndex);
    }

    public JavaScriptNode createAccessRestArgument(JSContext context, int index) {
        return AccessRestArgumentsNode.create(context, index);
    }

    public JavaScriptNode createAccessNewTarget() {
        return AccessIndexedArgumentNode.create(0);
    }

    public JavaScriptNode createAccessFrameArgument(ScopeFrameNode accessFrame, int argIndex) {
        return AccessFrameArgumentNode.create(accessFrame, argIndex);
    }

    public JavaScriptNode createAccessHomeObject(JSContext context) {
        return PropertyNode.createGetHidden(context, this.createAccessCallee(0), JSFunction.HOME_OBJECT_ID);
    }

    public ReadElementNode createReadElementNode(JSContext context, JavaScriptNode target, JavaScriptNode element) {
        return ReadElementNode.create(target, element, context);
    }

    public WriteElementNode createWriteElementNode(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict) {
        return WriteElementNode.create(targetNode, indexNode, valueNode, context, isStrict);
    }

    public WriteElementNode createCompoundWriteElementNode(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSWriteFrameSlotNode writeIndex, JSContext context, boolean isStrict) {
        return CompoundWriteElementNode.create(targetNode, indexNode, valueNode, writeIndex, context, isStrict);
    }

    public JSTargetableNode createReadProperty(JSContext context, JavaScriptNode base, TruffleString propertyName) {
        return PropertyNode.createProperty(context, base, propertyName);
    }

    public JSTargetableNode createReadProperty(JSContext context, JavaScriptNode base, TruffleString propertyName, boolean method) {
        return PropertyNode.createProperty(context, base, propertyName, method);
    }

    public WritePropertyNode createWriteProperty(JavaScriptNode target, TruffleString name, JavaScriptNode rhs, JSContext context, boolean strictMode) {
        return WritePropertyNode.create(target, name, rhs, context, strictMode);
    }

    public WritePropertyNode createWriteProperty(JavaScriptNode target, TruffleString name, JavaScriptNode rhs, JSContext context, boolean isStrict, boolean isGlobal, boolean verifyHasProperty) {
        return WritePropertyNode.create(target, name, rhs, context, isStrict, isGlobal, verifyHasProperty);
    }

    public ConstantVariableWriteNode createWriteConstantVariable(JavaScriptNode rhs, boolean doThrow) {
        return ConstantVariableWriteNode.create(rhs, doThrow);
    }

    public JSTargetableNode createReadGlobalProperty(JSContext context, TruffleString name) {
        return GlobalPropertyNode.createPropertyNode(context, name);
    }

    public JSTargetableNode createDeleteProperty(JavaScriptNode target, JavaScriptNode property, boolean strictMode, JSContext context) {
        return DeletePropertyNode.create(target, property, strictMode, context);
    }

    public FunctionRootNode createFunctionRootNode(AbstractBodyNode body, FrameDescriptor frameDescriptor, JSFunctionData functionData, SourceSection sourceSection, TruffleString internalFunctionName) {
        FunctionRootNode functionRoot = FunctionRootNode.create(body, frameDescriptor, functionData, sourceSection, internalFunctionName);
        functionData.setRootNode(functionRoot);
        functionData.setLazyInit(functionRoot);
        return functionRoot;
    }

    public FunctionRootNode createModuleRootNode(AbstractBodyNode linkBody, AbstractBodyNode evalBody, FrameDescriptor frameDescriptor, JSFunctionData functionData, SourceSection sourceSection, TruffleString internalFunctionName) {
        FunctionRootNode evalRoot;
        FunctionRootNode linkRoot;
        if (linkBody == evalBody) {
            evalRoot = linkRoot = FunctionRootNode.create(linkBody, frameDescriptor, functionData, sourceSection, internalFunctionName);
        } else {
            linkRoot = FunctionRootNode.create(linkBody, frameDescriptor, functionData, sourceSection, Strings.concat(internalFunctionName, Evaluator.MODULE_LINK_SUFFIX));
            evalRoot = FunctionRootNode.create(evalBody, JavaScriptRootNode.MODULE_DUMMY_FRAMEDESCRIPTOR, functionData, sourceSection, Strings.concat(internalFunctionName, Evaluator.MODULE_EVAL_SUFFIX));
        }
        functionData.setRootNode(linkRoot);
        RootCallTarget linkCallTarget = linkRoot.getCallTarget();
        RootCallTarget evalCallTarget = evalRoot.getCallTarget();
        functionData.setCallTarget(evalCallTarget);
        functionData.setConstructTarget(linkCallTarget);
        functionData.setConstructNewTarget(linkCallTarget);
        return linkRoot;
    }

    public ConstructorRootNode createConstructorRootNode(JSFunctionData functionData, CallTarget callTarget, boolean newTarget) {
        return ConstructorRootNode.create(functionData, callTarget, newTarget);
    }

    public FunctionBodyNode createFunctionBody(JavaScriptNode body) {
        return FunctionBodyNode.create(body);
    }

    public JSFunctionExpressionNode createFunctionExpression(JSFunctionData function, FunctionRootNode functionNode, JSFrameSlot blockScopeSlot) {
        return JSFunctionExpressionNode.create(function, blockScopeSlot);
    }

    public JSFunctionExpressionNode createFunctionExpressionLexicalThis(JSFunctionData function, FunctionRootNode functionNode, JSFrameSlot blockScopeSlot, JavaScriptNode thisNode) {
        return JSFunctionExpressionNode.createLexicalThis(function, blockScopeSlot, thisNode);
    }

    public JavaScriptNode createPrepareThisBinding(JSContext context, JavaScriptNode child) {
        return JSPrepareThisNode.createPrepareThisBinding(context, child);
    }

    public JavaScriptNode createGlobalObject() {
        return GlobalObjectNode.create();
    }

    public JavaScriptNode createArgumentsObjectNode(JSContext context, boolean unmapped, int leadingArgumentCount) {
        return ArgumentsObjectNode.create(context, unmapped, leadingArgumentCount);
    }

    public JavaScriptNode createThrowError(JSErrorType errorType, TruffleString message) {
        return RuntimeErrorNode.create(errorType, Strings.toJavaString(message));
    }

    public JavaScriptNode createObjectLiteral(JSContext context, ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members) {
        return ObjectLiteralNode.create(context, members.toArray(ObjectLiteralNode.ObjectLiteralMemberNode.EMPTY));
    }

    public JavaScriptNode createArrayLiteral(JSContext context, JavaScriptNode[] elements) {
        return ArrayLiteralNode.create(context, elements);
    }

    public JavaScriptNode createArrayLiteralWithSpread(JSContext context, JavaScriptNode[] elements) {
        return ArrayLiteralNode.createWithSpread(context, elements);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createAccessorMember(TruffleString keyName, boolean isStatic, boolean enumerable, JavaScriptNode getter, JavaScriptNode setter) {
        return ObjectLiteralNode.newAccessorMember(keyName, isStatic, enumerable, getter, setter);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createDataMember(TruffleString keyName, boolean isStatic, boolean enumerable, JavaScriptNode value, boolean isField) {
        return ObjectLiteralNode.newDataMember(keyName, isStatic, enumerable, value, isField);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createAutoAccessor(TruffleString keyName, boolean isStatic, boolean enumerable, JavaScriptNode value) {
        return ObjectLiteralNode.newAutoAccessor(keyName, isStatic, enumerable, value);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createComputedAutoAccessor(JavaScriptNode key, boolean isStatic, boolean enumerable, JavaScriptNode value) {
        return ObjectLiteralNode.newComputedAutoAccessor(key, isStatic, enumerable, value);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createProtoMember(TruffleString keyName, boolean isStatic, JavaScriptNode value) {
        return ObjectLiteralNode.newProtoMember(keyName, isStatic, value);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createComputedDataMember(JavaScriptNode key, boolean isStatic, boolean enumerable, JavaScriptNode value, boolean isField, boolean isAnonymousFunctionDefinition) {
        return ObjectLiteralNode.newComputedDataMember(key, isStatic, enumerable, value, isField, isAnonymousFunctionDefinition);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createComputedAccessorMember(JavaScriptNode key, boolean isStatic, boolean enumerable, JavaScriptNode getter, JavaScriptNode setter) {
        return ObjectLiteralNode.newComputedAccessorMember(key, isStatic, enumerable, getter, setter);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createSpreadObjectMember(boolean isStatic, JavaScriptNode value) {
        return ObjectLiteralNode.newSpreadObjectMember(isStatic, value);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createStaticBlockMember(JavaScriptNode value) {
        return ObjectLiteralNode.newStaticBlockMember(value);
    }

    public JavaScriptNode createClassDefinition(JSContext context, JSFunctionExpressionNode constructorFunction, JavaScriptNode classHeritage, ObjectLiteralNode.ObjectLiteralMemberNode[] members, JSWriteFrameSlotNode writeClassBinding, JSWriteFrameSlotNode writeInternalConstructorBrand, JavaScriptNode[] classDecorators, DecoratorListEvaluationNode[] memberDecorators, TruffleString className, int instanceFieldCount, int staticFieldCount, boolean hasPrivateInstanceMethods, JSFrameSlot blockScopeSlot) {
        return ClassDefinitionNode.create(context, constructorFunction, classHeritage, members, writeClassBinding, writeInternalConstructorBrand, className, classDecorators, memberDecorators, instanceFieldCount, staticFieldCount, hasPrivateInstanceMethods, blockScopeSlot);
    }

    public JavaScriptNode createMakeMethod(JSContext context, JavaScriptNode function) {
        return ObjectLiteralNode.MakeMethodNode.create(context, function);
    }

    public JavaScriptNode createSpreadArgument(JSContext context, GetIteratorNode getIteratorNode) {
        return SpreadArgumentNode.create(context, getIteratorNode);
    }

    public JavaScriptNode createSpreadArray(JSContext context, GetIteratorNode getIteratorNode) {
        return ArrayLiteralNode.SpreadArrayNode.create(context, getIteratorNode);
    }

    public ReturnNode createReturn(JavaScriptNode expression) {
        return ReturnNode.create(expression);
    }

    public ReturnNode createFrameReturn(JavaScriptNode expression) {
        return ReturnNode.createFrameReturn(expression);
    }

    public ReturnNode createTerminalPositionReturn(JavaScriptNode expression) {
        return ReturnNode.createTerminalPositionReturn(expression);
    }

    public JSFunctionData createFunctionData(JSContext context, int length, TruffleString name, boolean isConstructor, boolean isDerived, boolean isStrict, boolean isBuiltin, boolean needsParentFrame, boolean isGenerator, boolean isAsync, boolean isClassConstructor, boolean strictProperties, boolean needsNewTarget) {
        return JSFunctionData.create(context, null, null, null, length, name, isConstructor, isDerived, isStrict, isBuiltin, needsParentFrame, isGenerator, isAsync, isClassConstructor, strictProperties, needsNewTarget, false);
    }

    public JavaScriptNode createAwait(JSContext context, JSFrameSlot stateSlot, JavaScriptNode expression, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        return AwaitNode.create(context, stateSlot.getIndex(), expression, asyncContextNode, asyncResultNode);
    }

    public JavaScriptNode createYield(JSContext context, JSFrameSlot stateSlot, JavaScriptNode expression, JavaScriptNode yieldValue, boolean yieldStar, ReturnNode returnNode, JSWriteFrameSlotNode writeYieldResultNode) {
        if (yieldStar) {
            return YieldNode.createYieldStar(context, stateSlot.getIndex(), expression, yieldValue, returnNode, writeYieldResultNode);
        }
        return YieldNode.createYield(context, stateSlot.getIndex(), expression, yieldValue, returnNode, writeYieldResultNode);
    }

    public JavaScriptNode createAsyncGeneratorYield(JSContext context, JSFrameSlot stateSlot, JavaScriptNode expression, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode, ReturnNode returnNode) {
        return AsyncGeneratorYieldNode.createYield(context, stateSlot.getIndex(), expression, asyncContextNode, asyncResultNode, returnNode);
    }

    public JavaScriptNode createAsyncGeneratorYieldStar(JSContext context, JSFrameSlot stateSlot, JSFrameSlot iteratorTempSlot, JavaScriptNode expression, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode, ReturnNode returnNode) {
        return AsyncGeneratorYieldNode.createYieldStar(context, stateSlot.getIndex(), expression, asyncContextNode, asyncResultNode, returnNode, iteratorTempSlot.getIndex());
    }

    public JavaScriptNode createAsyncFunctionBody(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeAsyncContext, JSReadFrameSlotNode readAsyncContext, JSWriteFrameSlotNode writeAsyncResult) {
        return AsyncFunctionBodyNode.create(context, body, writeAsyncContext, readAsyncContext, writeAsyncResult);
    }

    public JavaScriptNode createGeneratorBody(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValue, JSReadFrameSlotNode readYieldResult) {
        return GeneratorBodyNode.create(context, body, writeYieldValue, readYieldResult);
    }

    public JavaScriptNode createAsyncGeneratorBody(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValue, JSReadFrameSlotNode readYieldResult, JSWriteFrameSlotNode writeAsyncContext, JSReadFrameSlotNode readAsyncContext) {
        return AsyncGeneratorBodyNode.create(context, body, writeYieldValue, readYieldResult, writeAsyncContext, readAsyncContext);
    }

    public JavaScriptNode createGeneratorWrapper(JavaScriptNode child, JSFrameSlot stateSlot) {
        return ResumableNode.createResumableNode((ResumableNode)((Object)child), stateSlot.getIndex());
    }

    public JavaScriptNode createGeneratorVoidBlock(JavaScriptNode[] statements, JSFrameSlot stateSlot) {
        return GeneratorVoidBlockNode.create(statements, stateSlot.getIndex());
    }

    public JavaScriptNode createGeneratorExprBlock(JavaScriptNode[] statements, JSFrameSlot stateSlot) {
        return GeneratorExprBlockNode.create(statements, stateSlot.getIndex());
    }

    public JavaScriptNode createBlockScope(JavaScriptNode block, JSFrameSlot blockScopeSlot, FrameDescriptor blockFrameDescriptor, JSFrameSlot parentSlot, boolean functionBlock, boolean captureFunctionFrame, boolean generatorFunctionBlock, boolean hasParentBlock, int frameStart, int frameEnd) {
        return BlockScopeNode.create(block, blockScopeSlot, blockFrameDescriptor, parentSlot, functionBlock, captureFunctionFrame, generatorFunctionBlock, hasParentBlock, frameStart, frameEnd);
    }

    public JavaScriptNode createVirtualBlockScope(JavaScriptNode block, int start, int end) {
        return BlockScopeNode.createVirtual(block, start, end);
    }

    public JavaScriptNode createTemplateObject(JSContext context, JavaScriptNode rawStrings, JavaScriptNode cookedStrings) {
        return GetTemplateObjectNode.create(context, (ArrayLiteralNode)rawStrings, (ArrayLiteralNode)cookedStrings);
    }

    public JavaScriptNode createToString(JavaScriptNode operand) {
        return JSToStringNode.JSToStringWrapperNode.create(operand);
    }

    public JavaScriptNode createRegExpLiteral(JSContext context, TruffleString pattern, TruffleString flags) {
        return RegExpLiteralNode.create(context, Strings.toJavaString(pattern), Strings.toJavaString(flags));
    }

    public GetIteratorNode createGetIterator(JSContext context, JavaScriptNode iteratedObject) {
        return GetIteratorNode.create(context, iteratedObject);
    }

    public JavaScriptNode createGetAsyncIterator(JSContext context, JavaScriptNode iteratedObject) {
        return GetIteratorNode.createAsync(context, iteratedObject);
    }

    public JavaScriptNode createEnumerate(JSContext context, JavaScriptNode iteratedObject, boolean values) {
        return EnumerateNode.create(context, iteratedObject, values);
    }

    public JavaScriptNode createIteratorNext(JavaScriptNode iterator) {
        return IteratorNextUnaryNode.create(iterator);
    }

    public JavaScriptNode createIteratorComplete(JSContext context, JavaScriptNode iterResult) {
        return IteratorCompleteUnaryNode.create(context, iterResult);
    }

    public JavaScriptNode createIteratorGetNextValue(JSContext context, JavaScriptNode iterator, JavaScriptNode doneNode, boolean setDoneOnError, boolean readValue) {
        return IteratorGetNextValueNode.create(context, iterator, doneNode, setDoneOnError, readValue);
    }

    public JavaScriptNode createIteratorSetDone(JavaScriptNode iterator, JavaScriptNode isDone) {
        return IteratorSetDoneNode.create(iterator, isDone);
    }

    public JavaScriptNode createIteratorIsDone(JavaScriptNode iterator) {
        return IteratorIsDoneNode.create(iterator);
    }

    public JavaScriptNode createAsyncIteratorNext(JSContext context, JSFrameSlot stateSlot, JavaScriptNode createReadNode, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        return AsyncIteratorNextNode.create(context, stateSlot.getIndex(), createReadNode, asyncContextNode, asyncResultNode);
    }

    public JavaScriptNode createIteratorValue(JavaScriptNode iterator) {
        return IteratorValueNode.create(iterator);
    }

    public JavaScriptNode createAsyncIteratorCloseWrapper(JSContext context, JSFrameSlot stateSlot, JavaScriptNode loopNode, JavaScriptNode iterator, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        return AsyncIteratorCloseWrapperNode.create(context, stateSlot.getIndex(), loopNode, iterator, asyncContextNode, asyncResultNode);
    }

    public JavaScriptNode createIteratorCloseIfNotDone(JSContext context, JavaScriptNode block, JavaScriptNode iterator) {
        return IteratorCloseWrapperNode.create(context, block, iterator);
    }

    public IteratorToArrayNode createIteratorToArray(JSContext context, JavaScriptNode iterator) {
        return IteratorToArrayNode.create(context, iterator);
    }

    public JavaScriptNode createGetPrototype(JavaScriptNode object) {
        return GetPrototypeNode.create(object);
    }

    public JSTargetableNode createSuperPropertyReference(JavaScriptNode delegate, JavaScriptNode target) {
        return SuperPropertyReferenceNode.create(delegate, target);
    }

    public JSTargetableNode createTargetableWrapper(JavaScriptNode delegate, JavaScriptNode target) {
        return JSTargetableWrapperNode.create(delegate, target);
    }

    public JavaScriptNode createWith(JavaScriptNode expression, JavaScriptNode statement) {
        return WithNode.create(expression, statement);
    }

    public JavaScriptNode createWithVarWrapper(TruffleString propertyName, JavaScriptNode withTarget, JSTargetableNode withAccessNode, JavaScriptNode globalDelegate) {
        return WithVarWrapperNode.create(propertyName, withTarget, withAccessNode, globalDelegate);
    }

    public JavaScriptNode createWithTarget(JSContext context, TruffleString propertyName, JavaScriptNode withVariable) {
        return WithTargetNode.create(context, propertyName, withVariable);
    }

    public JavaScriptRootNode createNewTargetConstruct(JSContext context, CallTarget callTarget) {
        return NewTargetRootNode.createNewTargetConstruct(context.getLanguage(), callTarget);
    }

    public JavaScriptRootNode createNewTargetCall(JSContext context, CallTarget callTarget) {
        return NewTargetRootNode.createNewTargetCall(context.getLanguage(), callTarget);
    }

    public JavaScriptRootNode createDropNewTarget(JSContext context, CallTarget callTarget) {
        return NewTargetRootNode.createDropNewTarget(context.getLanguage(), callTarget);
    }

    public JavaScriptRootNode createConstructorRequiresNewRoot(JSFunctionData functionData, SourceSection sourceSection) {
        JSContext context = functionData.getContext();
        final String message = "Class constructor " + functionData.getName() + " cannot be invoked without 'new'";
        return new JavaScriptRealmBoundaryRootNode(context.getLanguage(), sourceSection, null){

            @Override
            protected Object executeInRealm(VirtualFrame frame) {
                throw Errors.createTypeError(message);
            }
        };
    }

    public JavaScriptNode createDerivedConstructorResult(JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        return ConstructorResultNode.createDerived(bodyNode, thisNode);
    }

    public JavaScriptNode createDerivedConstructorThis(JavaScriptNode thisNode) {
        return AccessDerivedConstructorThisNode.create(thisNode);
    }

    public JavaScriptNode createDefaultDerivedConstructorSuperCall(JavaScriptNode function) {
        assert (function instanceof JSTargetableWrapperNode);
        JavaScriptNode superFunction = ((JSTargetableWrapperNode)function).getDelegate();
        JavaScriptNode target = ((JSTargetableWrapperNode)function).getTarget();
        return DefaultDerivedConstructorSuperCallNode.create(superFunction, target);
    }

    public JavaScriptNode createRequireObjectCoercible(JavaScriptNode argument) {
        return RequireObjectCoercibleNode.RequireObjectCoercibleWrapperNode.create(argument);
    }

    public JSFrameDescriptor createFunctionFrameDescriptor() {
        return new JSFrameDescriptor(Undefined.instance);
    }

    public JSFrameDescriptor createBlockFrameDescriptor() {
        JSFrameDescriptor desc = new JSFrameDescriptor(Undefined.instance);
        desc.addFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER, FrameSlotKind.Object);
        return desc;
    }

    public DeclareGlobalNode createDeclareGlobalVariable(TruffleString varName, boolean configurable) {
        return DeclareGlobalVariableNode.create(varName, configurable);
    }

    public DeclareGlobalNode createDeclareGlobalFunction(TruffleString varName, boolean configurable, JavaScriptNode valueNode) {
        return DeclareGlobalFunctionNode.create(varName, configurable, valueNode);
    }

    public DeclareGlobalNode createDeclareGlobalLexicalVariable(TruffleString varName, boolean isConst) {
        return DeclareGlobalLexicalVariableNode.create(varName, isConst);
    }

    public JavaScriptNode createGlobalDeclarationInstantiation(JSContext context, List<DeclareGlobalNode> declarations) {
        return GlobalDeclarationInstantiationNode.create(context, declarations);
    }

    public JavaScriptNode copy(JavaScriptNode node) {
        return node.copy();
    }

    public JavaScriptNode createToObject(JSContext context, JavaScriptNode operand) {
        return JSToObjectNode.JSToObjectWrapperNode.createToObject(context, operand);
    }

    public JavaScriptNode createToObjectFromWith(JSContext context, JavaScriptNode operand, boolean checkForNullOrUndefined) {
        return JSToObjectNode.JSToObjectWrapperNode.createToObjectFromWith(context, operand, checkForNullOrUndefined);
    }

    public JavaScriptNode createAccessArgumentsArrayDirectly(JavaScriptNode writeArguments, JavaScriptNode readArguments, int leadingArgCount) {
        return new AccessArgumentsArrayDirectlyNode(writeArguments, readArguments, leadingArgCount);
    }

    public JavaScriptNode createCallApplyArguments(JSFunctionCallNode callNode) {
        return CallApplyArgumentsNode.create(callNode);
    }

    public JavaScriptNode createGuardDisconnectedArgumentRead(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, JSFrameSlot slot) {
        return JSGuardDisconnectedArgumentRead.create(index, readElementNode, argumentsArray, (TruffleString)slot.getIdentifier());
    }

    public JavaScriptNode createGuardDisconnectedArgumentWrite(int index, WriteElementNode argumentsArrayAccess, JavaScriptNode argumentsArray, JavaScriptNode rhs, JSFrameSlot slot) {
        return JSGuardDisconnectedArgumentWrite.create(index, argumentsArrayAccess, argumentsArray, rhs, (TruffleString)slot.getIdentifier());
    }

    public JavaScriptNode createModuleBody(JavaScriptNode moduleBody) {
        return ModuleBodyNode.create(moduleBody);
    }

    public JavaScriptNode createModuleInitializeEnvironment(JavaScriptNode moduleBody) {
        return ModuleInitializeEnvironmentNode.create(moduleBody);
    }

    public JavaScriptNode createModuleYield() {
        return ModuleYieldNode.create();
    }

    public JavaScriptNode createTopLevelAsyncModuleBody(JSContext context, JavaScriptNode moduleBody, JSWriteFrameSlotNode asyncResult, JSWriteFrameSlotNode writeAsyncContextNode) {
        return TopLevelAwaitModuleBodyNode.create(context, moduleBody, asyncResult, writeAsyncContextNode);
    }

    public JavaScriptNode createImportMeta(JavaScriptNode moduleNode) {
        return ImportMetaNode.create(moduleNode);
    }

    public JavaScriptNode createResolveStarImport(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, JSWriteFrameSlotNode writeLocalNode) {
        return ResolveStarImportNode.create(context, moduleNode, moduleRequest, writeLocalNode);
    }

    public JavaScriptNode createResolveNamedImport(JSContext context, JavaScriptNode moduleNode, Module.ModuleRequest moduleRequest, TruffleString importName, JSWriteFrameSlotNode writeLocalNode) {
        return ResolveNamedImportNode.create(context, moduleNode, moduleRequest, importName, writeLocalNode);
    }

    public JavaScriptNode createReadImportBinding(JavaScriptNode readLocal) {
        return ReadImportBindingNode.create(readLocal);
    }

    public JavaScriptNode createImportCall(JSContext context, JavaScriptNode argument, JavaScriptNode activeScriptOrModule) {
        return ImportCallNode.create(context, argument, activeScriptOrModule);
    }

    public JavaScriptNode createImportCall(JSContext context, JavaScriptNode specifier, JavaScriptNode activeScriptOrModule, JavaScriptNode options) {
        return ImportCallNode.createWithOptions(context, specifier, activeScriptOrModule, options);
    }

    public JavaScriptNode createRestObject(JSContext context, JavaScriptNode source, JavaScriptNode excludedNames) {
        ObjectLiteralNode restObj = ObjectLiteralNode.create(context, ObjectLiteralNode.ObjectLiteralMemberNode.EMPTY);
        return RestObjectNode.create(context, restObj, source, excludedNames);
    }

    public JavaScriptNode createInitializeInstanceElements(JSContext context, JavaScriptNode target, JavaScriptNode constructor) {
        return InitializeInstanceElementsNode.create(context, target, constructor);
    }

    public JavaScriptNode createNewPrivateName(TruffleString description) {
        return NewPrivateNameNode.create(Strings.toJavaString(description));
    }

    public JavaScriptNode createPrivateFieldGet(JSContext context, JavaScriptNode target, JavaScriptNode key) {
        return PrivateFieldGetNode.create(target, key, context);
    }

    public JavaScriptNode createPrivateFieldSet(JSContext context, JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode) {
        return PrivateFieldSetNode.create(targetNode, indexNode, valueNode, context);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createPrivateFieldMember(JavaScriptNode keyNode, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
        return ObjectLiteralNode.newPrivateFieldMember(keyNode, isStatic, valueNode, writePrivateNode);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createPrivateMethodMember(TruffleString privateName, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode, int privateBrandSlotIndex) {
        return ObjectLiteralNode.newPrivateMethodMember(privateName, isStatic, valueNode, writePrivateNode, privateBrandSlotIndex);
    }

    public ObjectLiteralNode.ObjectLiteralMemberNode createPrivateAccessorMember(boolean isStatic, JavaScriptNode getterNode, JavaScriptNode setterNode, JSWriteFrameSlotNode writePrivateNode, int privateBrandSlotIndex) {
        return ObjectLiteralNode.newPrivateAccessorMember(isStatic, getterNode, setterNode, writePrivateNode, privateBrandSlotIndex);
    }

    public JavaScriptNode createPrivateBrandCheck(JavaScriptNode targetNode, JavaScriptNode brandNode) {
        return PrivateBrandCheckNode.create(targetNode, brandNode);
    }

    public JavaScriptNode createGetPrivateBrand(JSContext context, JavaScriptNode constructorNode) {
        return JSAndNode.create(constructorNode, PropertyNode.createGetHidden(context, constructorNode, JSFunction.PRIVATE_BRAND_ID));
    }

    public JavaScriptNode createToPropertyKey(JavaScriptNode key) {
        return JSToPropertyKeyNode.JSToPropertyKeyWrapperNode.create(key);
    }

    public JavaScriptNode createOptionalChain(JavaScriptNode accessNode) {
        return OptionalChainNode.createTarget(accessNode);
    }

    public JavaScriptNode createOptionalChainShortCircuit(JavaScriptNode valueNode) {
        return OptionalChainNode.createShortCircuit(valueNode);
    }

    public JavaScriptNode createNamedEvaluation(JavaScriptNode expressionNode, JavaScriptNode nameNode) {
        return NamedEvaluationNode.create(expressionNode, nameNode);
    }

    public IfNode copyIfWithCondition(IfNode origIfNode, JavaScriptNode condition) {
        return IfNode.create(condition, origIfNode.getThenPart(), origIfNode.getElsePart());
    }

    public JavaScriptNode createDebugScope(JSContext context, JavaScriptNode function) {
        return PropertyNode.createGetHidden(context, function, JSFunction.DEBUG_SCOPE_ID);
    }

    public JavaScriptNode createDebugVarWrapper(TruffleString varName, JavaScriptNode defaultDelegate, JavaScriptNode dynamicScope, JSTargetableNode scopeAccessNode) {
        return new DebugScopeVarWrapperNode(varName, defaultDelegate, dynamicScope, scopeAccessNode);
    }

    public InternalSlotId createInternalSlotId(TruffleString description, int ordinal) {
        return new InternalSlotId(description, ordinal);
    }

    public JavaScriptNode createPrivateFieldIn(JavaScriptNode left, JavaScriptNode right) {
        return PrivateFieldInNode.create(left, right);
    }

    public static NodeFactory getDefaultInstance() {
        return FACTORY;
    }

    public static NodeFactory getInstance(JSContext context) {
        return (NodeFactory)context.getNodeFactory();
    }

    public static enum UnaryOperation {
        MINUS,
        PLUS,
        BITWISE_COMPLEMENT,
        NOT,
        POSTFIX_LOCAL_INCREMENT,
        PREFIX_LOCAL_INCREMENT,
        POSTFIX_LOCAL_DECREMENT,
        PREFIX_LOCAL_DECREMENT,
        TYPE_OF,
        VOID;

    }

    public static enum BinaryOperation {
        ADD,
        DIVIDE,
        MODULO,
        MULTIPLY,
        EXPONENTIATE,
        SUBTRACT,
        EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        IDENTICAL,
        LESS_OR_EQUAL,
        LESS,
        NOT_EQUAL,
        NOT_IDENTICAL,
        BITWISE_XOR,
        BITWISE_AND,
        BITWISE_OR,
        BITWISE_LEFT_SHIFT,
        BITWISE_RIGHT_SHIFT,
        BITWISE_UNSIGNED_RIGHT_SHIFT,
        LOGICAL_AND,
        LOGICAL_OR,
        INSTANCEOF,
        IN,
        DUAL,
        NULLISH_COALESCING;

    }
}

